<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Employee extends Model 
{

    protected $table = 'employees';
    public $timestamps = true;

    public function branch()
    {
        return $this->belongsTo('Branch', 'branch_id');
    }

    public function addresses()
    {
        return $this->hasMany('Address', 'addressable');
    }

    public function phones()
    {
        return $this->morphMany('Phone', 'phoneable');
    }

}